document.addEventListener('DOMContentLoaded', () => {
    // Mobile Menu Toggle
    const btn = document.querySelector('.mobile-menu-btn');
    const menu = document.querySelector('.nav-list');

    if (btn && menu) {
        btn.addEventListener('click', () => {
            menu.classList.toggle('active');
            const icon = btn.querySelector('i');
            if (menu.classList.contains('active')) {
                icon.classList.remove('fa-bars');
                icon.classList.add('fa-times');
            } else {
                icon.classList.remove('fa-times');
                icon.classList.add('fa-bars');
            }
        });

        // Close menu when clicking a link
        menu.querySelectorAll('a').forEach(link => {
            link.addEventListener('click', () => {
                menu.classList.remove('active');
                const icon = btn.querySelector('i');
                icon.classList.remove('fa-times');
                icon.classList.add('fa-bars');
            });
        });
    }

    // Navbar Scroll Effect
    const header = document.querySelector('.header'); // Changed from getElementById('header') to querySelector('.header')
    if (header) {
        window.addEventListener('scroll', () => {
            if (window.scrollY > 50) {
                header.style.backgroundColor = 'rgba(5, 5, 5, 0.95)';
                header.style.boxShadow = '0 4px 20px rgba(0, 0, 0, 0.5)';
            } else {
                header.style.backgroundColor = 'rgba(5, 5, 5, 0.8)';
                header.style.boxShadow = 'none';
            }
        });
    }

    // Smooth Scroll for Anchor Links
    document.querySelectorAll('a[href^="#"]').forEach(anchor => {
        anchor.addEventListener('click', function (e) {
            e.preventDefault();
            const targetId = this.getAttribute('href');
            if (targetId === '#') return;
            
            const targetElement = document.querySelector(targetId);
            if (targetElement) {
                const headerHeight = header ? header.offsetHeight : 0;
                const elementPosition = targetElement.getBoundingClientRect().top;
                const offsetPosition = elementPosition + window.pageYOffset - headerHeight;

                window.scrollTo({
                    top: offsetPosition,
                    behavior: "smooth"
                });
            }
        });
    });

    // Stats Counter Animation
    const stats = document.querySelectorAll('.stat-number');
    const observerOptions = {
        threshold: 0.5
    };

    const statsObserver = new IntersectionObserver((entries, observer) => {
        entries.forEach(entry => {
            if (entry.isIntersecting) {
                const target = entry.target;
                const targetValue = target.getAttribute('data-target');
                
                if (targetValue) {
                    let startValue = 0;
                    const duration = 2000;
                    const increment = targetValue / (duration / 16);
                    
                    const updateCounter = () => {
                        startValue += increment;
                        if (startValue < targetValue) {
                            target.innerText = Math.ceil(startValue) + (target.innerText.includes('%') ? '%' : '+');
                            requestAnimationFrame(updateCounter);
                        } else {
                            target.innerText = targetValue + (target.innerText.includes('%') ? '%' : '+');
                        }
                    };
                    
                    updateCounter();
                    observer.unobserve(target);
                }
            }
        });
    }, observerOptions);

    stats.forEach(stat => {
        if (stat.getAttribute('data-target')) {
            statsObserver.observe(stat);
        }
    });

    // Form Submission Handling (WhatsApp)
    const contactForm = document.getElementById('contactForm');
    if (contactForm) {
        contactForm.addEventListener('submit', (e) => {
            e.preventDefault();
            
            const name = document.getElementById('nombre').value;
            const message = document.getElementById('mensaje').value;
            
            const whatsappNumber = "50662020446";
            const text = `Hola soy ${name} y me gustaría automatizar ${message}`;
            const encodedText = encodeURIComponent(text);
            const whatsappUrl = `https://wa.me/${whatsappNumber}?text=${encodedText}`;
            
            window.open(whatsappUrl, '_blank');
            contactForm.reset();
        });
    }

    
});
